%% SEIR simulation plots

% Plots a comparison of population classes for multiple scenarios
%
% Uses seir_sim.m, 2020/10/27 version
%
% User specifies a list of values for one of the key parameters:
%   R0 is the basic reproductive number
%   TL is the mean incubation time
%   TI is the mean infectious duration
%   I0 is the initial infectious fraction
%   V is the initial immune fraction
%
% The program is designed so that only two lines need to be modified to
% make a new experiment (see '%%%' comments)
%     line 43 defines the independent variable values
%     line 67 links the independent variable name and values
% The legend is optional
%
% output figure:
%   left panel: S vs time
%   right panel: I vs time
%
% by Glenn Ledder
% written 2020/08/15
% revised 2020/10/27
%
% direct comments to gledder@unl.edu

%% DEFAULT SCENARIO DATA

R0 = 2.5;
TL = 5;
TI = 10;
I0 = 0.001;
V = 0;

%% INDEPENDENT VARIABLE DATA

%%% This section needs to be modified for each experiment.

%%% xvals is the set of independent variable values
xvals = [5,4,3,2];

%% COMMON DATA

target = 0.001;

%% INITIALIZATION

opengl hardwarebasic;
clf
for k=1:2
    subplot(1,2,k)
    hold on
    xlabel('days')
end

N = length(xvals);

%% COMPUTATION and PLOTS

for n=1:N
    
    %%% The left side of this statement needs to be the independent
    %%% variable for the experiment.
    R0 = xvals(n);

    eta = 1/TL;
    gamma = 1/TI;
    beta = gamma*R0;

    b = eta+gamma;
    c = eta*(gamma-beta*(1-V));
    lambda = 0.5*(sqrt(b^2-4*c)-b);
    rho = (lambda+gamma)/eta;
    E0 = rho*I0;

    [S,~,I,~] = seir_sim(beta,eta,gamma,E0,I0,V,target);
    days = length(I)-1;
    
    subplot(1,2,1)
    plot(0:days,S,'LineWidth',1.7)
    subplot(1,2,2)
    plot(0:days,I,'LineWidth',1.7)
end

subplot(1,2,1)
ylim([0,1])
ylabel('susceptible')
subplot(1,2,2)
ylabel('infectious')
legend('R0=5','R0=4','R0=3','R0=2','Location','Northeast')
